import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {OtherRoomMaster, OtherRoomMasterRelations} from '../models';

export class OtherRoomMasterRepository extends DefaultCrudRepository<
  OtherRoomMaster,
  typeof OtherRoomMaster.prototype.otherRoomId,
  OtherRoomMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(OtherRoomMaster, dataSource);
  }
}
