import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BuyerMaster, LogBuyer, LogBuyerRelations, PostPropertyMaster} from '../models';
import {BuyerMasterRepository} from './buyer-master.repository';
import {PostPropertyMasterRepository} from './post-property-master.repository';

export class LogBuyerRepository extends DefaultCrudRepository<
  LogBuyer,
  typeof LogBuyer.prototype.logBuyerId,
  LogBuyerRelations
> {
  // BelongsTo accessor for buyer
  public readonly buyer: BelongsToAccessor<BuyerMaster, typeof LogBuyer.prototype.logBuyerId>;

  // BelongsTo accessor for postProperty
  public readonly postProperty: BelongsToAccessor<PostPropertyMaster, typeof LogBuyer.prototype.logBuyerId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('BuyerMasterRepository') protected buyerMasterRepoGetter: Getter<BuyerMasterRepository>,
    @repository.getter('PostPropertyMasterRepository') protected postPropertyMasterRepoGetter: Getter<PostPropertyMasterRepository>,
  ) {
    super(LogBuyer, dataSource);

    // Create BelongsTo accessor for buyer
    this.buyer = this.createBelongsToAccessorFor('buyer', buyerMasterRepoGetter);
    this.registerInclusionResolver('buyer', this.buyer.inclusionResolver);

    // Create BelongsTo accessor for postProperty
    this.postProperty = this.createBelongsToAccessorFor('postProperty', postPropertyMasterRepoGetter);
    this.registerInclusionResolver('postProperty', this.postProperty.inclusionResolver);
  }
}
