import {Getter, inject} from '@loopback/core';
import {DefaultCrudRepository, HasManyRepositoryFactory, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BuyerMaster, GenderMaster, GenderMasterRelations, SellerMaster} from '../models';
import {BuyerMasterRepository} from './buyer-master.repository';
import {SellerMasterRepository} from './seller-master.repository';

export class GenderMasterRepository extends DefaultCrudRepository<
  GenderMaster,
  typeof GenderMaster.prototype.genderId,
  GenderMasterRelations
> {
   public readonly sellers: HasManyRepositoryFactory<SellerMaster, typeof GenderMaster.prototype.genderId>;
  public readonly buyers: HasManyRepositoryFactory<BuyerMaster, typeof GenderMaster.prototype.genderId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
     @repository.getter('SellerMasterRepository') protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>,
    @repository.getter('BuyerMasterRepository') protected buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>,
  ) {
    super(GenderMaster, dataSource);

    this.buyers = this.createHasManyRepositoryFactoryFor('buyers', buyerMasterRepositoryGetter);
    this.registerInclusionResolver('buyers', this.buyers.inclusionResolver);

    this.sellers = this.createHasManyRepositoryFactoryFor('sellers', sellerMasterRepositoryGetter);
    this.registerInclusionResolver('sellers', this.sellers.inclusionResolver);
  }
}
