import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {FacingMaster, FacingMasterRelations} from '../models';

export class FacingMasterRepository extends DefaultCrudRepository<
  FacingMaster,
  typeof FacingMaster.prototype.facingId,
  FacingMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(FacingMaster, dataSource);
  }
}
