import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {DurationMaster, DurationMasterRelations} from '../models';

export class DurationMasterRepository extends DefaultCrudRepository<
  DurationMaster,
  typeof DurationMaster.prototype.durationId,
  DurationMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(DurationMaster, dataSource);
  }
}
