import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BestPropertyMaster, BestPropertyMasterRelations} from '../models';

export class BestPropertyMasterRepository extends DefaultCrudRepository<
  BestPropertyMaster,
  typeof BestPropertyMaster.prototype.bestPropertyId,
  BestPropertyMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(BestPropertyMaster, dataSource);
  }
}
