import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BackgroundImageMaster, BackgroundImageMasterRelations} from '../models';

export class BackgroundImageMasterRepository extends DefaultCrudRepository<
  BackgroundImageMaster,
  typeof BackgroundImageMaster.prototype.backImgId,
  BackgroundImageMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(BackgroundImageMaster, dataSource);
  }
}
