// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {AdsManagement, AdsManagementRelations} from '../models';

// export class AdsManagementRepository extends DefaultCrudRepository<
//   AdsManagement,
//   typeof AdsManagement.prototype.adsId,
//   AdsManagementRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(AdsManagement, dataSource);
//   }
// }

import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {AdsManagement, AdsTypeMaster} from '../models';
import {AdsTypeMasterRepository} from './ads-type-master.repository';

export class AdsManagementRepository extends DefaultCrudRepository<
  AdsManagement,
  typeof AdsManagement.prototype.adsId
> {
  public readonly adsType: BelongsToAccessor<AdsTypeMaster, typeof AdsManagement.prototype.adsId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('AdsTypeMasterRepository')
    protected adsTypeMasterRepositoryGetter: Getter<AdsTypeMasterRepository>,
  ) {
    super(AdsManagement, dataSource);

    this.adsType = this.createBelongsToAccessorFor('adsType', adsTypeMasterRepositoryGetter);
    this.registerInclusionResolver('adsType', this.adsType.inclusionResolver);
  }
}
