/* eslint-disable @typescript-eslint/naming-convention */
import {belongsTo, Entity, hasMany, model, property} from '@loopback/repository';
import {AvailableStatusMaster} from './available-status-master.model';
// import {CityMaster} from './city-master.model';
import {AmenitiesMaster} from './amenities-master.model';
import {FacingMaster} from './facing-master.model';
import {FloorMaster} from './floor-master.model';
import {FurnishingtypeMaster} from './furnishingtype-master.model';
import {MainProperttyTypeMaster} from './main-propertty-type-master.model';
import {MaintenanceMonthMaster} from './maintenance-month-master.model';
import {OtherRoomMaster} from './other-room-master.model';
import {OwnershipMaster} from './ownership-master.model';
import {PossessionMaster} from './possession-master.model';
import {PostPropertyAmenities} from './post-property-amenities.model';
import {PostTypeMaster} from './post-type-master.model';
import {PropertyTypeMaster} from './property-type-master.model';
import {PublishTypeMaster} from './publish-type-master.model';
import {SellerMaster} from './seller-master.model';
import {TransactionTypeMaster} from './transaction-type-master.model';
import {Usertype} from './usertype.model';


@model({
  settings: {
    idInjection: false,
    mysql: {schema: 'lelloproperty', table: 'post_property_master'},

  }
})
export class PostPropertyMaster extends Entity {
  @property({
    type: 'number',
    // // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'annualduespay', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  annualduespay: number;

  @property({
    type: 'string',
    // // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'apartmentName/areaName', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  apartmentNameAreaName: string;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'bookingamount', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  bookingamount: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'builduparea', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  builduparea: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'carpetarea', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  carpetarea: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'coverparking', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  coverparking: number;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false},
  })
  createdBy?: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  createdDate?: string;

  @property({
    type: 'string',
    jsonSchema: {nullable: true},
    length: 200,
    generated: false,
    mysql: {columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  deleteRemark?: string;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false},
  })
  deletedBy?: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  deletedDate?: string;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'description', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  description: string;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'expectedrental', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  expectedrental: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkavailablestatusId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkavailablestatusId: number;


  @belongsTo(() => AvailableStatusMaster, {name: 'availableStatus'})
  fkavailablestatusId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fksellerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fksellerId: number;


  @belongsTo(() => SellerMaster, {name: 'seller'})
  fksellerId: number;
  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'publish_Fag', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  publish_Fag: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkpublish_TypeId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkpublish_TypeId: number;


  @belongsTo(() => PublishTypeMaster, {name: 'publishType'})
  fkpublish_TypeId: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'publish_StartDate', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  publish_StartDate?: string;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'publish_EndDate', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  publish_EndDate?: string;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'fkcityId', dataType: 'varchar', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  fkcityId: string;


  // @belongsTo(() => CityMaster, {name: 'city'})
  // fkcityId: number;
  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkfloorId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkfloorId: number;


  @belongsTo(() => FloorMaster, {name: 'floor'})
  fkfloorId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkfurnishingtypeId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkfurnishingtypeId: number;


  @belongsTo(() => FurnishingtypeMaster, {name: 'furnishingType'})
  fkfurnishingtypeId: number;

  @belongsTo(() => TransactionTypeMaster, {name: 'transactionType'})
  fktransactionId: number;

  @belongsTo(() => PossessionMaster, {name: 'possessionType'})
  fkpossessionId: number;

  @belongsTo(() => FacingMaster, {name: 'facing'})
  fkfacingId: number;

  // @belongsTo(() => AmenitiesMaster, {name: 'amenities'})
  // fkamenitiesId: number;

  @hasMany(() => AmenitiesMaster, {
    through: {
      model: () => PostPropertyAmenities,
      keyFrom: 'postpropertyId',
      keyTo: 'amenitiesId'
    }
  })
  amenities: AmenitiesMaster[];

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'fklocalityId', dataType: 'varchar', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  fklocalityId: string;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkmainpropertytypeId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkmainpropertytypeId: number;


  @belongsTo(() => MainProperttyTypeMaster, {name: 'mainPropertyType'})
  fkmainpropertytypeId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkmaintnecemonthId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkmaintnecemonthId: number;


  @belongsTo(() => MaintenanceMonthMaster, {name: 'maintenanceMonth'})
  fkmaintnecemonthId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkotherrooms', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkotherrooms: number;

  @belongsTo(() => OtherRoomMaster, {name: 'otherRoom'})
  fkotherrooms: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkownershipId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkownershipId: number;

  @belongsTo(() => OwnershipMaster, {name: 'ownership'})
  fkownershipId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkuserId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkuserId: number;


  @belongsTo(() => Usertype, {name: 'userType'})
  fkuserId: number;


  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkpostpropertytypeId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkpostpropertytypeId: number;


  @belongsTo(() => PostTypeMaster, {name: 'postType'})
  fkpostpropertytypeId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 10,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'fkpropertytypeId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  // })
  // fkpropertytypeId: number;



  @belongsTo(() => PropertyTypeMaster, {name: 'propertyType'})
  fkpropertytypeId: number;

  // @property({
  //   type: 'number',
  //   // required: true,
  //   jsonSchema: {nullable: false},
  //   precision: 19,
  //   scale: 0,
  //   generated: false,
  //   mysql: {columnName: 'housenumber', dataType: 'bigint', dataLength: null, dataPrecision: 19, dataScale: 0, nullable: 'N', generated: false},
  // })
  // housenumber: number;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'housenumber', dataType: 'varchar', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  housenumber: string;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 3,
    scale: 0,
    generated: false,
    mysql: {columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false},
  })
  isActive?: number;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 3,
    scale: 0,
    generated: false,
    mysql: {columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false},
  })
  isDefault?: number;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 3,
    scale: 0,
    generated: false,
    mysql: {columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false},
  })
  isOn?: number;

  @property({
    type: 'date',
    // required: true,
    jsonSchema: {nullable: false},
    generated: false,
    mysql: {columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  lastChanged: string;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'maintenance', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  maintenance: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'membershipcharge', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  membershipcharge: number;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false},
  })
  modifiedBy?: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  modifiedDate?: string;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'noofbalkanies', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  noofbalkanies: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'noofbathrooms', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  noofbathrooms: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'noofbedrooms', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  noofbedrooms: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'openparking', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  openparking: number;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 65535,
    generated: false,
    mysql: {columnName: 'photo', dataType: 'text', dataLength: 65535, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  photo: string;


  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'photos', dataType: 'text', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'y', generated: false},
  })
  photos: string;
  @property({
    type: 'number',
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: 1,
    id: 1,
    mysql: {columnName: 'postpropertyId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1},
  })
  postpropertyId?: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'price', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  price: number;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 65535,
    generated: false,
    mysql: {columnName: 'RERA_NO', dataType: 'text', dataLength: 65535, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  RERA_NO: string;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'RERA_is_active', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  RERA_is_active: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'pricepersqft', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  pricepersqft: number;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'sublocality', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  sublocality: string;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'Property_Title', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  Property_Title: string;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'Property_Description', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  Property_Description: string;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 2,
    generated: false,
    mysql: {columnName: 'supperbuilduparea', dataType: 'double', dataLength: null, dataPrecision: 10, dataScale: 2, nullable: 'N', generated: false},
  })
  supperbuilduparea: number;

  @property({
    type: 'number',
    // required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'totalfloor', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  totalfloor: number;

  @property({
    type: 'string',
    // required: true,
    jsonSchema: {nullable: false},
    length: 255,
    generated: false,
    mysql: {columnName: 'video', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  video: string;




  // Indexer property to allow additional data
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  [prop: string]: any;

  constructor(data?: Partial<PostPropertyMaster>) {
    super(data);
  }
}

export interface PostPropertyMasterRelations {
  // describe navigational properties here
  amenities?: AmenitiesMaster[];
}

export type PostPropertyMasterWithRelations = PostPropertyMaster & PostPropertyMasterRelations;
