import {
  Count,
  CountSchema,
  Filter,
  FilterExcludingWhere,
  repository,
  Where,
} from '@loopback/repository';
import {
  post,
  param,
  get,
  getModelSchemaRef,
  patch,
  put,
  del,
  requestBody,
  response,
} from '@loopback/rest';
import {LogBuyersearch} from '../models';
import {LogBuyersearchRepository} from '../repositories';

export class LogBuyersearchController {
  constructor(
    @repository(LogBuyersearchRepository)
    public logBuyersearchRepository : LogBuyersearchRepository,
  ) {}

  @post('/log-buyersearches')
  @response(200, {
    description: 'LogBuyersearch model instance',
    content: {'application/json': {schema: getModelSchemaRef(LogBuyersearch)}},
  })
  async create(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(LogBuyersearch, {
            title: 'NewLogBuyersearch',
            exclude: ['logBuyersearchId'],
          }),
        },
      },
    })
    logBuyersearch: Omit<LogBuyersearch, 'logBuyersearchId'>,
  ): Promise<LogBuyersearch> {
    return this.logBuyersearchRepository.create(logBuyersearch);
  }

  @get('/log-buyersearches/count')
  @response(200, {
    description: 'LogBuyersearch model count',
    content: {'application/json': {schema: CountSchema}},
  })
  async count(
    @param.where(LogBuyersearch) where?: Where<LogBuyersearch>,
  ): Promise<Count> {
    return this.logBuyersearchRepository.count(where);
  }

  @get('/log-buyersearches')
  @response(200, {
    description: 'Array of LogBuyersearch model instances',
    content: {
      'application/json': {
        schema: {
          type: 'array',
          items: getModelSchemaRef(LogBuyersearch, {includeRelations: true}),
        },
      },
    },
  })
  async find(
    @param.filter(LogBuyersearch) filter?: Filter<LogBuyersearch>,
  ): Promise<LogBuyersearch[]> {
    return this.logBuyersearchRepository.find(filter);
  }

  @patch('/log-buyersearches')
  @response(200, {
    description: 'LogBuyersearch PATCH success count',
    content: {'application/json': {schema: CountSchema}},
  })
  async updateAll(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(LogBuyersearch, {partial: true}),
        },
      },
    })
    logBuyersearch: LogBuyersearch,
    @param.where(LogBuyersearch) where?: Where<LogBuyersearch>,
  ): Promise<Count> {
    return this.logBuyersearchRepository.updateAll(logBuyersearch, where);
  }

  @get('/log-buyersearches/{id}')
  @response(200, {
    description: 'LogBuyersearch model instance',
    content: {
      'application/json': {
        schema: getModelSchemaRef(LogBuyersearch, {includeRelations: true}),
      },
    },
  })
  async findById(
    @param.path.number('id') id: number,
    @param.filter(LogBuyersearch, {exclude: 'where'}) filter?: FilterExcludingWhere<LogBuyersearch>
  ): Promise<LogBuyersearch> {
    return this.logBuyersearchRepository.findById(id, filter);
  }

  @patch('/log-buyersearches/{id}')
  @response(204, {
    description: 'LogBuyersearch PATCH success',
  })
  async updateById(
    @param.path.number('id') id: number,
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(LogBuyersearch, {partial: true}),
        },
      },
    })
    logBuyersearch: LogBuyersearch,
  ): Promise<void> {
    await this.logBuyersearchRepository.updateById(id, logBuyersearch);
  }

  @put('/log-buyersearches/{id}')
  @response(204, {
    description: 'LogBuyersearch PUT success',
  })
  async replaceById(
    @param.path.number('id') id: number,
    @requestBody() logBuyersearch: LogBuyersearch,
  ): Promise<void> {
    await this.logBuyersearchRepository.replaceById(id, logBuyersearch);
  }

  @del('/log-buyersearches/{id}')
  @response(204, {
    description: 'LogBuyersearch DELETE success',
  })
  async deleteById(@param.path.number('id') id: number): Promise<void> {
    await this.logBuyersearchRepository.deleteById(id);
  }
}
