import { BootMixin } from '@loopback/boot';
import { ApplicationConfig } from '@loopback/core';
import {
  RestExplorerBindings,
  RestExplorerComponent,
} from '@loopback/rest-explorer';
import { RepositoryMixin } from '@loopback/repository';
import { RestApplication } from '@loopback/rest';
import { ServiceMixin } from '@loopback/service-proxy';
import path from 'path';
import { MySequence } from './sequence';
import {PostPropertyAmenitiesRepository} from './repositories';
import {PostPropertyAmenities} from './models';


export { ApplicationConfig };

export class LelloBackendApplication extends BootMixin(
  ServiceMixin(RepositoryMixin(RestApplication)),
) {
  constructor(options: ApplicationConfig = {}) {
    super(options);

    this.model(PostPropertyAmenities);
    this.repository(PostPropertyAmenitiesRepository);

    this.static('/uploads/seller-profiles', path.join(__dirname, '../uploads/seller-profiles'));
    this.static('/uploads/Slider-Photo', path.join(__dirname, '../uploads/Slider-Photo'));
    this.static('/uploads/property-images', path.join(__dirname, '../uploads/property-images'));
    this.static('/uploads/testimonial-images', path.join(__dirname, '../uploads/testimonial-images'));
    this.static('/uploads/real-estate-images', path.join(__dirname, '../uploads/real-estate-images'));
    this.static('/uploads/ads', path.join(__dirname, '../uploads/ads'));
    this.static('/uploads/packages', path.join(__dirname, '../uploads/packages'));

     this.projectRoot = __dirname;
    // Customize @loopback/boot Booter Conventions here
    this.bootOptions = {
      controllers: {
        // Customize ControllerBooter Conventions here
        dirs: ['controllers'],
        extensions: ['.controller.js'],
        nested: true,
      },
    };

    // Set up the custom sequence
    this.sequence(MySequence);

    // Set up default home page
    this.static('/', path.join(__dirname, '../public'));

    // Customize @loopback/rest-explorer configuration here
    this.configure(RestExplorerBindings.COMPONENT).to({
      path: '/explorer',
    });
    this.component(RestExplorerComponent);

    this.projectRoot = __dirname;
    // Customize @loopback/boot Booter Conventions here
    this.bootOptions = {
      controllers: {
        // Customize ControllerBooter Conventions here
        dirs: ['controllers'],
        extensions: ['.controller.js'],
        nested: true,
      },
    };
  }
}
