"use strict";
// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {Usertype, UsertypeRelations} from '../models';
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsertypeRepository = void 0;
const tslib_1 = require("tslib");
// export class UsertypeRepository extends DefaultCrudRepository<
//   Usertype,
//   typeof Usertype.prototype.userId,
//   UsertypeRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(Usertype, dataSource);
//   }
// }
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let UsertypeRepository = class UsertypeRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, sellerMasterRepositoryGetter, buyerMasterRepositoryGetter) {
        super(models_1.Usertype, dataSource);
        this.sellerMasterRepositoryGetter = sellerMasterRepositoryGetter;
        this.buyerMasterRepositoryGetter = buyerMasterRepositoryGetter;
        this.sellers = this.createHasManyRepositoryFactoryFor('sellers', sellerMasterRepositoryGetter);
        this.registerInclusionResolver('sellers', this.sellers.inclusionResolver);
        this.buyers = this.createHasManyRepositoryFactoryFor('buyers', buyerMasterRepositoryGetter);
        this.registerInclusionResolver('buyers', this.buyers.inclusionResolver);
    }
};
exports.UsertypeRepository = UsertypeRepository;
exports.UsertypeRepository = UsertypeRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('SellerMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('BuyerMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function])
], UsertypeRepository);
//# sourceMappingURL=usertype.repository.js.map