import { Getter } from '@loopback/core';
import { DefaultCrudRepository, HasManyRepositoryFactory } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, SellerMaster, Usertype, UsertypeRelations } from '../models';
import { BuyerMasterRepository } from './buyer-master.repository';
import { SellerMasterRepository } from './seller-master.repository';
export declare class UsertypeRepository extends DefaultCrudRepository<Usertype, typeof Usertype.prototype.userId, UsertypeRelations> {
    protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>;
    protected buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>;
    readonly sellers: HasManyRepositoryFactory<SellerMaster, typeof Usertype.prototype.userId>;
    readonly buyers: HasManyRepositoryFactory<BuyerMaster, typeof Usertype.prototype.userId>;
    constructor(dataSource: DblelloDataSource, sellerMasterRepositoryGetter: Getter<SellerMasterRepository>, buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>);
}
