"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuyerMasterRepository = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let BuyerMasterRepository = class BuyerMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, cityMasterRepositoryGetter, usertypeRepositoryGetter) {
        super(models_1.BuyerMaster, dataSource);
        this.cityMasterRepositoryGetter = cityMasterRepositoryGetter;
        this.usertypeRepositoryGetter = usertypeRepositoryGetter;
        this.city = this.createBelongsToAccessorFor('fkcityId', cityMasterRepositoryGetter);
        this.registerInclusionResolver('fkcityId', this.city.inclusionResolver);
        this.usertype = this.createBelongsToAccessorFor('fkusertypeId', usertypeRepositoryGetter);
        this.registerInclusionResolver('fkusertypeId', this.usertype.inclusionResolver);
    }
};
exports.BuyerMasterRepository = BuyerMasterRepository;
exports.BuyerMasterRepository = BuyerMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.db')),
    tslib_1.__param(1, repository_1.repository.getter('CityMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('UsertypeRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function])
], BuyerMasterRepository);
//# sourceMappingURL=relations-inclusions.js.map