import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, CityMaster, Usertype } from '../models';
import { CityMasterRepository } from './city-master.repository';
import { UsertypeRepository } from './usertype.repository';
export declare class BuyerMasterRepository extends DefaultCrudRepository<BuyerMaster, typeof BuyerMaster.prototype.id> {
    protected cityMasterRepositoryGetter: Getter<CityMasterRepository>;
    protected usertypeRepositoryGetter: Getter<UsertypeRepository>;
    readonly city: BelongsToAccessor<CityMaster, typeof BuyerMaster.prototype.id>;
    readonly usertype: BelongsToAccessor<Usertype, typeof BuyerMaster.prototype.id>;
    constructor(dataSource: DblelloDataSource, cityMasterRepositoryGetter: Getter<CityMasterRepository>, usertypeRepositoryGetter: Getter<UsertypeRepository>);
}
