import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository, HasManyThroughRepositoryFactory } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { AmenitiesMaster, AvailableStatusMaster, FacingMaster, FloorMaster, FurnishingtypeMaster, MainProperttyTypeMaster, MaintenanceMonthMaster, OtherRoomMaster, OwnershipMaster, PossessionMaster, PostPropertyAmenities, PostPropertyMaster, PostPropertyMasterRelations, PostTypeMaster, PropertyTypeMaster, PublishTypeMaster, SellerMaster, TransactionTypeMaster, Usertype } from '../models';
import { AmenitiesMasterRepository } from './amenities-master.repository';
import { AvailableStatusMasterRepository } from './available-status-master.repository';
import { FacingMasterRepository } from './facing-master.repository';
import { FloorMasterRepository } from './floor-master.repository';
import { FurnishingtypeMasterRepository } from './furnishingtype-master.repository';
import { MainProperttyTypeMasterRepository } from './main-propertty-type-master.repository';
import { MaintenanceMonthMasterRepository } from './maintenance-month-master.repository';
import { OtherRoomMasterRepository } from './other-room-master.repository';
import { OwnershipMasterRepository } from './ownership-master.repository';
import { PossessionMasterRepository } from './possession-master.repository';
import { PostPropertyAmenitiesRepository } from './post-property-amenities.repository';
import { PostTypeMasterRepository } from './post-type-master.repository';
import { PropertyTypeMasterRepository } from './property-type-master.repository';
import { PublishTypeMasterRepository } from './publish-type-master.repository';
import { SellerMasterRepository } from './seller-master.repository';
import { TransactionTypeMasterRepository } from './transaction-type-master.repository';
import { UsertypeRepository } from './usertype.repository';
export declare class PostPropertyMasterRepository extends DefaultCrudRepository<PostPropertyMaster, typeof PostPropertyMaster.prototype.postpropertyId, PostPropertyMasterRelations> {
    protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>;
    protected publishTypeMasterRepositoryGetter: Getter<PublishTypeMasterRepository>;
    protected furnishingTypeMasterRepositoryGetter: Getter<FurnishingtypeMasterRepository>;
    protected possessionMasterRepositoryGetter: Getter<PossessionMasterRepository>;
    protected transactionTypeMasterRepositoryGetter: Getter<TransactionTypeMasterRepository>;
    protected floorMasterRepositoryGetter: Getter<FloorMasterRepository>;
    protected mainPropertyTypeMasterRepositoryGetter: Getter<MainProperttyTypeMasterRepository>;
    protected maintenanceMonthMasterRepositoryGetter: Getter<MaintenanceMonthMasterRepository>;
    protected otherRoomMasterRepositoryGetter: Getter<OtherRoomMasterRepository>;
    protected ownershipMasterRepositoryGetter: Getter<OwnershipMasterRepository>;
    protected userTypeRepositoryGetter: Getter<UsertypeRepository>;
    protected postTypeMasterRepositoryGetter: Getter<PostTypeMasterRepository>;
    protected propertyTypeMasterRepositoryGetter: Getter<PropertyTypeMasterRepository>;
    protected availableStatusMasterRepositoryGetter: Getter<AvailableStatusMasterRepository>;
    protected facingMasterRepositoryGetter: Getter<FacingMasterRepository>;
    protected amenitiesRepositoryGetter: Getter<AmenitiesMasterRepository>;
    protected propertyAmenitiesRepositoryGetter: Getter<PostPropertyAmenitiesRepository>;
    readonly seller: BelongsToAccessor<SellerMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly publishType: BelongsToAccessor<PublishTypeMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly furnishingType: BelongsToAccessor<FurnishingtypeMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly possessionType: BelongsToAccessor<PossessionMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly transactionType: BelongsToAccessor<TransactionTypeMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly floor: BelongsToAccessor<FloorMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly mainPropertyType: BelongsToAccessor<MainProperttyTypeMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly maintenanceMonth: BelongsToAccessor<MaintenanceMonthMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly otherRoom: BelongsToAccessor<OtherRoomMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly ownership: BelongsToAccessor<OwnershipMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly userType: BelongsToAccessor<Usertype, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly postType: BelongsToAccessor<PostTypeMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly propertyType: BelongsToAccessor<PropertyTypeMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly availableStatus: BelongsToAccessor<AvailableStatusMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly facing: BelongsToAccessor<FacingMaster, typeof PostPropertyMaster.prototype.postpropertyId>;
    readonly amenities: HasManyThroughRepositoryFactory<AmenitiesMaster, typeof AmenitiesMaster.prototype.amenitiesId, PostPropertyAmenities, typeof PostPropertyMaster.prototype.postpropertyId>;
    constructor(dataSource: DblelloDataSource, sellerMasterRepositoryGetter: Getter<SellerMasterRepository>, publishTypeMasterRepositoryGetter: Getter<PublishTypeMasterRepository>, furnishingTypeMasterRepositoryGetter: Getter<FurnishingtypeMasterRepository>, possessionMasterRepositoryGetter: Getter<PossessionMasterRepository>, transactionTypeMasterRepositoryGetter: Getter<TransactionTypeMasterRepository>, floorMasterRepositoryGetter: Getter<FloorMasterRepository>, mainPropertyTypeMasterRepositoryGetter: Getter<MainProperttyTypeMasterRepository>, maintenanceMonthMasterRepositoryGetter: Getter<MaintenanceMonthMasterRepository>, otherRoomMasterRepositoryGetter: Getter<OtherRoomMasterRepository>, ownershipMasterRepositoryGetter: Getter<OwnershipMasterRepository>, userTypeRepositoryGetter: Getter<UsertypeRepository>, postTypeMasterRepositoryGetter: Getter<PostTypeMasterRepository>, propertyTypeMasterRepositoryGetter: Getter<PropertyTypeMasterRepository>, availableStatusMasterRepositoryGetter: Getter<AvailableStatusMasterRepository>, facingMasterRepositoryGetter: Getter<FacingMasterRepository>, amenitiesRepositoryGetter: Getter<AmenitiesMasterRepository>, propertyAmenitiesRepositoryGetter: Getter<PostPropertyAmenitiesRepository>);
}
