import { Getter } from '@loopback/core';
import { DefaultCrudRepository, BelongsToAccessor } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { AmenitiesMaster, PostPropertyAmenities, PostPropertyAmenitiesRelations, PostPropertyMaster } from '../models';
import { PostPropertyMasterRepository } from './post-property-master.repository';
import { AmenitiesMasterRepository } from './amenities-master.repository';
export declare class PostPropertyAmenitiesRepository extends DefaultCrudRepository<PostPropertyAmenities, typeof PostPropertyAmenities.prototype.id, PostPropertyAmenitiesRelations> {
    protected postPropertyMasterRepositoryGetter: Getter<PostPropertyMasterRepository>;
    protected amenitiesMasterRepositoryGetter: Getter<AmenitiesMasterRepository>;
    readonly postProperty: BelongsToAccessor<PostPropertyMaster, typeof PostPropertyAmenities.prototype.id>;
    readonly amenity: BelongsToAccessor<AmenitiesMaster, typeof PostPropertyAmenities.prototype.id>;
    constructor(dataSource: DblelloDataSource, postPropertyMasterRepositoryGetter: Getter<PostPropertyMasterRepository>, amenitiesMasterRepositoryGetter: Getter<AmenitiesMasterRepository>);
}
