"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageMasterRepository = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let PackageMasterRepository = class PackageMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, usertypeRepositoryGetter) {
        super(models_1.PackageMaster, dataSource);
        this.usertypeRepositoryGetter = usertypeRepositoryGetter;
        this.usertype = this.createBelongsToAccessorFor('usertype', usertypeRepositoryGetter);
        this.registerInclusionResolver('usertype', this.usertype.inclusionResolver);
    }
};
exports.PackageMasterRepository = PackageMasterRepository;
exports.PackageMasterRepository = PackageMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('UsertypeRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function])
], PackageMasterRepository);
//# sourceMappingURL=package-master.repository.js.map