import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, LogProperty, LogPropertyRelations, PostPropertyMaster, SellerMaster, Usertype } from '../models';
import { BuyerMasterRepository } from './buyer-master.repository';
import { PostPropertyMasterRepository } from './post-property-master.repository';
import { SellerMasterRepository } from './seller-master.repository';
import { UsertypeRepository } from './usertype.repository';
export declare class LogPropertyRepository extends DefaultCrudRepository<LogProperty, typeof LogProperty.prototype.logPropertyId, LogPropertyRelations> {
    protected usertypeRepoGetter: Getter<UsertypeRepository>;
    protected buyerRepoGetter: Getter<BuyerMasterRepository>;
    protected sellerRepoGetter: Getter<SellerMasterRepository>;
    protected postPropertyRepoGetter: Getter<PostPropertyMasterRepository>;
    readonly usertype: BelongsToAccessor<Usertype, typeof LogProperty.prototype.logPropertyId>;
    readonly buyer: BelongsToAccessor<BuyerMaster, typeof LogProperty.prototype.logPropertyId>;
    readonly seller: BelongsToAccessor<SellerMaster, typeof LogProperty.prototype.logPropertyId>;
    readonly postProperty: BelongsToAccessor<PostPropertyMaster, typeof LogProperty.prototype.logPropertyId>;
    constructor(dataSource: DblelloDataSource, usertypeRepoGetter: Getter<UsertypeRepository>, buyerRepoGetter: Getter<BuyerMasterRepository>, sellerRepoGetter: Getter<SellerMasterRepository>, postPropertyRepoGetter: Getter<PostPropertyMasterRepository>);
}
