import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, LogBuyer, LogBuyerRelations, PostPropertyMaster } from '../models';
import { BuyerMasterRepository } from './buyer-master.repository';
import { PostPropertyMasterRepository } from './post-property-master.repository';
export declare class LogBuyerRepository extends DefaultCrudRepository<LogBuyer, typeof LogBuyer.prototype.logBuyerId, LogBuyerRelations> {
    protected buyerMasterRepoGetter: Getter<BuyerMasterRepository>;
    protected postPropertyMasterRepoGetter: Getter<PostPropertyMasterRepository>;
    readonly buyer: BelongsToAccessor<BuyerMaster, typeof LogBuyer.prototype.logBuyerId>;
    readonly postProperty: BelongsToAccessor<PostPropertyMaster, typeof LogBuyer.prototype.logBuyerId>;
    constructor(dataSource: DblelloDataSource, buyerMasterRepoGetter: Getter<BuyerMasterRepository>, postPropertyMasterRepoGetter: Getter<PostPropertyMasterRepository>);
}
