import { Getter } from '@loopback/core';
import { DefaultCrudRepository, HasManyRepositoryFactory } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, GenderMaster, GenderMasterRelations, SellerMaster } from '../models';
import { BuyerMasterRepository } from './buyer-master.repository';
import { SellerMasterRepository } from './seller-master.repository';
export declare class GenderMasterRepository extends DefaultCrudRepository<GenderMaster, typeof GenderMaster.prototype.genderId, GenderMasterRelations> {
    protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>;
    protected buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>;
    readonly sellers: HasManyRepositoryFactory<SellerMaster, typeof GenderMaster.prototype.genderId>;
    readonly buyers: HasManyRepositoryFactory<BuyerMaster, typeof GenderMaster.prototype.genderId>;
    constructor(dataSource: DblelloDataSource, sellerMasterRepositoryGetter: Getter<SellerMasterRepository>, buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>);
}
