import { Getter } from '@loopback/core';
import { DefaultCrudRepository, HasManyRepositoryFactory } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, CityMaster, CityMasterRelations, SellerMaster } from '../models';
import { BuyerMasterRepository } from './buyer-master.repository';
import { SellerMasterRepository } from './seller-master.repository';
export declare class CityMasterRepository extends DefaultCrudRepository<CityMaster, typeof CityMaster.prototype.cityId, CityMasterRelations> {
    protected buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>;
    protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>;
    readonly buyers: HasManyRepositoryFactory<BuyerMaster, typeof CityMaster.prototype.cityId>;
    readonly sellers: HasManyRepositoryFactory<SellerMaster, typeof CityMaster.prototype.cityId>;
    constructor(dataSource: DblelloDataSource, buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>, sellerMasterRepositoryGetter: Getter<SellerMasterRepository>);
}
