import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { BuyerMaster, BuyerMasterRelations, CityMaster, GenderMaster, Usertype } from '../models';
import { CityMasterRepository } from './city-master.repository';
import { GenderMasterRepository } from './gender-master.repository';
import { UsertypeRepository } from './usertype.repository';
export declare class BuyerMasterRepository extends DefaultCrudRepository<BuyerMaster, typeof BuyerMaster.prototype.buyerId, BuyerMasterRelations> {
    protected cityRepoGetter: Getter<CityMasterRepository>;
    protected genderRepoGetter: Getter<GenderMasterRepository>;
    protected usertypeRepoGetter: Getter<UsertypeRepository>;
    readonly city: BelongsToAccessor<CityMaster, typeof BuyerMaster.prototype.buyerId>;
    readonly gender: BelongsToAccessor<GenderMaster, typeof BuyerMaster.prototype.buyerId>;
    readonly usertype: BelongsToAccessor<Usertype, typeof BuyerMaster.prototype.buyerId>;
    constructor(dataSource: DblelloDataSource, cityRepoGetter: Getter<CityMasterRepository>, genderRepoGetter: Getter<GenderMasterRepository>, usertypeRepoGetter: Getter<UsertypeRepository>);
}
