"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddToCartRepository = void 0;
const tslib_1 = require("tslib");
/* eslint-disable @typescript-eslint/no-explicit-any */
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let AddToCartRepository = class AddToCartRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, usertypeRepoGetter, buyerRepoGetter, sellerRepoGetter, postPropertyRepoGetter) {
        super(models_1.AddToCart, dataSource);
        this.usertypeRepoGetter = usertypeRepoGetter;
        this.buyerRepoGetter = buyerRepoGetter;
        this.sellerRepoGetter = sellerRepoGetter;
        this.postPropertyRepoGetter = postPropertyRepoGetter;
        this.usertype = this.createBelongsToAccessorFor('usertype', usertypeRepoGetter);
        this.buyer = this.createBelongsToAccessorFor('buyer', buyerRepoGetter);
        this.seller = this.createBelongsToAccessorFor('seller', sellerRepoGetter);
        this.postProperty = this.createBelongsToAccessorFor('postProperty', postPropertyRepoGetter);
        this.registerInclusionResolver('usertype', this.usertype.inclusionResolver);
        this.registerInclusionResolver('buyer', this.buyer.inclusionResolver);
        this.registerInclusionResolver('seller', this.seller.inclusionResolver);
        this.registerInclusionResolver('postProperty', this.postProperty.inclusionResolver);
        // Override the default inclusion resolver for buyer to only include when fkUsertypeId = 1
        this.registerInclusionResolver('buyer', async (entities) => {
            const buyerRepo = await buyerRepoGetter();
            const results = [];
            for (const entity of entities) {
                // Only fetch buyer if usertype is 1 (buyer)
                if (entity.fkUsertypeId === 1 && entity.fkBuyerIdSellerId) {
                    try {
                        const buyer = await buyerRepo.findById(entity.fkBuyerIdSellerId, {
                            include: [{ relation: 'city' }, { relation: 'gender' }, { relation: 'usertype' }]
                        });
                        results.push(buyer);
                    }
                    catch (error) {
                        console.error(`Error fetching buyer with ID ${entity.fkBuyerIdSellerId}:`, error);
                        // Buyer not found, push undefined
                        results.push(undefined);
                    }
                }
                else {
                    // Not a buyer, push undefined
                    results.push(undefined);
                }
            }
            return results;
        });
        // Override the default inclusion resolver for seller to only include when fkUsertypeId != 1
        this.registerInclusionResolver('seller', async (entities) => {
            const sellerRepo = await sellerRepoGetter();
            const results = [];
            for (const entity of entities) {
                // Only fetch seller if usertype is NOT 1 (i.e., seller or other)
                if (entity.fkUsertypeId !== 1 && entity.fkBuyerIdSellerId) {
                    try {
                        const seller = await sellerRepo.findById(entity.fkBuyerIdSellerId, {
                            include: [{ relation: 'city' }, { relation: 'package' }, { relation: 'user' }, { relation: 'gender' }]
                        });
                        results.push(seller);
                    }
                    catch (error) {
                        console.error(`Error fetching seller with ID ${entity.fkBuyerIdSellerId}:`, error);
                        // Seller not found, push undefined
                        results.push(undefined);
                    }
                }
                else {
                    // Not a seller, push undefined
                    results.push(undefined);
                }
            }
            return results;
        });
    }
};
exports.AddToCartRepository = AddToCartRepository;
exports.AddToCartRepository = AddToCartRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('UsertypeRepository')),
    tslib_1.__param(2, repository_1.repository.getter('BuyerMasterRepository')),
    tslib_1.__param(3, repository_1.repository.getter('SellerMasterRepository')),
    tslib_1.__param(4, repository_1.repository.getter('PostPropertyMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function, Function, Function])
], AddToCartRepository);
//# sourceMappingURL=add-to-cart.repository.js.map