import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { AddToCart, AddToCartRelations, BuyerMaster, PostPropertyMaster, SellerMaster, Usertype } from '../models';
import { BuyerMasterRepository } from './buyer-master.repository';
import { PostPropertyMasterRepository } from './post-property-master.repository';
import { SellerMasterRepository } from './seller-master.repository';
import { UsertypeRepository } from './usertype.repository';
export declare class AddToCartRepository extends DefaultCrudRepository<AddToCart, typeof AddToCart.prototype.addTocartId, AddToCartRelations> {
    protected usertypeRepoGetter: Getter<UsertypeRepository>;
    protected buyerRepoGetter: Getter<BuyerMasterRepository>;
    protected sellerRepoGetter: Getter<SellerMasterRepository>;
    protected postPropertyRepoGetter: Getter<PostPropertyMasterRepository>;
    readonly usertype: BelongsToAccessor<Usertype, typeof AddToCart.prototype.addTocartId>;
    readonly buyer: BelongsToAccessor<BuyerMaster, typeof AddToCart.prototype.addTocartId>;
    readonly seller: BelongsToAccessor<SellerMaster, typeof AddToCart.prototype.addTocartId>;
    readonly postProperty: BelongsToAccessor<PostPropertyMaster, typeof AddToCart.prototype.addTocartId>;
    constructor(dataSource: DblelloDataSource, usertypeRepoGetter: Getter<UsertypeRepository>, buyerRepoGetter: Getter<BuyerMasterRepository>, sellerRepoGetter: Getter<SellerMasterRepository>, postPropertyRepoGetter: Getter<PostPropertyMasterRepository>);
}
