"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostPropertyAmenities = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const post_property_master_model_1 = require("./post-property-master.model");
const amenities_master_model_1 = require("./amenities-master.model");
let PostPropertyAmenities = class PostPropertyAmenities extends repository_1.Entity {
    constructor(data) {
        super(data);
    }
};
exports.PostPropertyAmenities = PostPropertyAmenities;
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: 1,
        id: 1,
        mysql: { columnName: 'id', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1 },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "id", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fkpostpropertyId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "postpropertyId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fkamenitiesId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "amenitiesId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => post_property_master_model_1.PostPropertyMaster, {
        name: 'postProperty',
        keyFrom: 'postpropertyId',
        keyTo: 'postpropertyId'
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "fkpostpropertyId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => amenities_master_model_1.AmenitiesMaster, {
        name: 'amenity',
        keyFrom: 'amenitiesId',
        keyTo: 'amenitiesId'
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "fkamenitiesId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "isDefault", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "isOn", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "isActive", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PostPropertyAmenities.prototype, "createdDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "createdBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PostPropertyAmenities.prototype, "modifiedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "modifiedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PostPropertyAmenities.prototype, "deletedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PostPropertyAmenities.prototype, "deletedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        jsonSchema: { nullable: true },
        length: 200,
        generated: false,
        mysql: { columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PostPropertyAmenities.prototype, "deleteRemark", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PostPropertyAmenities.prototype, "lastChanged", void 0);
exports.PostPropertyAmenities = PostPropertyAmenities = tslib_1.__decorate([
    (0, repository_1.model)({
        settings: {
            idInjection: false,
            mysql: { schema: 'lelloproperty', table: 'post_property_amenities' },
        }
    }),
    tslib_1.__metadata("design:paramtypes", [Object])
], PostPropertyAmenities);
//# sourceMappingURL=post-property-amenities.model.js.map