import { Entity } from '@loopback/repository';
import { BuyerMaster } from './buyer-master.model';
import { SellerMaster } from './seller-master.model';
export declare class CityMaster extends Entity {
    cityId?: number;
    cityName: string;
    state: string;
    country: string;
    isDefault?: number;
    isOn?: number;
    isActive?: number;
    createdDate?: string;
    createdBy?: number;
    modifiedDate?: string;
    modifiedBy?: number;
    deletedDate?: string;
    deletedBy?: number;
    deleteRemark?: string;
    lastChanged: string;
    [prop: string]: any;
    buyers: BuyerMaster[];
    sellers: SellerMaster[];
    constructor(data?: Partial<CityMaster>);
}
export interface CityMasterRelations {
    buyers?: BuyerMaster[];
    sellers?: SellerMaster[];
}
export type CityMasterWithRelations = CityMaster & CityMasterRelations;
