"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddToCart = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const buyer_master_model_1 = require("./buyer-master.model");
const post_property_master_model_1 = require("./post-property-master.model");
const seller_master_model_1 = require("./seller-master.model");
const usertype_model_1 = require("./usertype.model");
let AddToCart = class AddToCart extends repository_1.Entity {
    constructor(data) {
        super(data);
    }
};
exports.AddToCart = AddToCart;
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: 1,
        id: 1,
        mysql: { columnName: 'add_tocartId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1 },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "addTocartId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fk_buyerId_sellerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "fkBuyerIdSellerId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => post_property_master_model_1.PostPropertyMaster, { name: 'postProperty' }, {
        mysql: {
            columnName: 'fk_postpropertyId',
            dataType: 'int',
            dataPrecision: 10,
            nullable: 'N',
            generated: false,
        }
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "fkPostpropertyId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => usertype_model_1.Usertype, { name: 'usertype' }, {
        mysql: {
            columnName: 'fk_usertypeId',
            dataType: 'int',
            dataPrecision: 10,
            nullable: 'N',
            generated: false,
        }
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "fkUsertypeId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => buyer_master_model_1.BuyerMaster, { name: 'buyer', keyFrom: 'fkBuyerIdSellerId' }, {
        mysql: {
            columnName: 'fk_buyerId_sellerId',
            dataType: 'int',
            dataPrecision: 10,
            nullable: 'N',
            generated: false,
        }
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "buyerId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => seller_master_model_1.SellerMaster, { name: 'seller', keyFrom: 'fkBuyerIdSellerId' }, {
        mysql: {
            columnName: 'fk_buyerId_sellerId',
            dataType: 'int',
            dataPrecision: 10,
            nullable: 'N',
            generated: false,
        }
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "sellerId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'Date', dataType: 'date', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "date", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'Time', dataType: 'time', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "time", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "isDefault", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "isOn", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "isActive", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "createdDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "createdBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "modifiedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "modifiedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "deletedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AddToCart.prototype, "deletedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        jsonSchema: { nullable: true },
        length: 200,
        generated: false,
        mysql: { columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "deleteRemark", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AddToCart.prototype, "lastChanged", void 0);
exports.AddToCart = AddToCart = tslib_1.__decorate([
    (0, repository_1.model)({
        settings: { idInjection: false, mysql: { schema: 'lelloproperty', table: 'add_to_cart' } }
    }),
    tslib_1.__metadata("design:paramtypes", [Object])
], AddToCart);
//# sourceMappingURL=add-to-cart.model.js.map