"use strict";
// import {
//   Count,
//   CountSchema,
//   Filter,
//   FilterExcludingWhere,
//   repository,
//   Where,
// } from '@loopback/repository';
// import {
//   post,
//   param,
//   get,
//   getModelSchemaRef,
//   patch,
//   put,
//   del,
//   requestBody,
//   response,
// } from '@loopback/rest';
// import {Usertype} from '../models';
// import {UsertypeRepository} from '../repositories';
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsertypeController = void 0;
const tslib_1 = require("tslib");
// export class UsertypeController {
//   constructor(
//     @repository(UsertypeRepository)
//     public usertypeRepository : UsertypeRepository,
//   ) {}
//   @post('/usertypes')
//   @response(200, {
//     description: 'Usertype model instance',
//     content: {'application/json': {schema: getModelSchemaRef(Usertype)}},
//   })
//   async create(
//     @requestBody({
//       content: {
//         'application/json': {
//           schema: getModelSchemaRef(Usertype, {
//             title: 'NewUsertype',
//             exclude: ['userId'],
//           }),
//         },
//       },
//     })
//     usertype: Omit<Usertype, 'userId'>,
//   ): Promise<Usertype> {
//     return this.usertypeRepository.create(usertype);
//   }
//   @get('/usertypes/count')
//   @response(200, {
//     description: 'Usertype model count',
//     content: {'application/json': {schema: CountSchema}},
//   })
//   async count(
//     @param.where(Usertype) where?: Where<Usertype>,
//   ): Promise<Count> {
//     return this.usertypeRepository.count(where);
//   }
//   @get('/usertypes')
//   @response(200, {
//     description: 'Array of Usertype model instances',
//     content: {
//       'application/json': {
//         schema: {
//           type: 'array',
//           items: getModelSchemaRef(Usertype, {includeRelations: true}),
//         },
//       },
//     },
//   })
//   async find(
//     @param.filter(Usertype) filter?: Filter<Usertype>,
//   ): Promise<Usertype[]> {
//     return this.usertypeRepository.find(filter);
//   }
//   @patch('/usertypes')
//   @response(200, {
//     description: 'Usertype PATCH success count',
//     content: {'application/json': {schema: CountSchema}},
//   })
//   async updateAll(
//     @requestBody({
//       content: {
//         'application/json': {
//           schema: getModelSchemaRef(Usertype, {partial: true}),
//         },
//       },
//     })
//     usertype: Usertype,
//     @param.where(Usertype) where?: Where<Usertype>,
//   ): Promise<Count> {
//     return this.usertypeRepository.updateAll(usertype, where);
//   }
//   @get('/usertypes/{id}')
//   @response(200, {
//     description: 'Usertype model instance',
//     content: {
//       'application/json': {
//         schema: getModelSchemaRef(Usertype, {includeRelations: true}),
//       },
//     },
//   })
//   async findById(
//     @param.path.number('id') id: number,
//     @param.filter(Usertype, {exclude: 'where'}) filter?: FilterExcludingWhere<Usertype>
//   ): Promise<Usertype> {
//     return this.usertypeRepository.findById(id, filter);
//   }
//   @patch('/usertypes/{id}')
//   @response(204, {
//     description: 'Usertype PATCH success',
//   })
//   async updateById(
//     @param.path.number('id') id: number,
//     @requestBody({
//       content: {
//         'application/json': {
//           schema: getModelSchemaRef(Usertype, {partial: true}),
//         },
//       },
//     })
//     usertype: Usertype,
//   ): Promise<void> {
//     await this.usertypeRepository.updateById(id, usertype);
//   }
//   @put('/usertypes/{id}')
//   @response(204, {
//     description: 'Usertype PUT success',
//   })
//   async replaceById(
//     @param.path.number('id') id: number,
//     @requestBody() usertype: Usertype,
//   ): Promise<void> {
//     await this.usertypeRepository.replaceById(id, usertype);
//   }
//   @del('/usertypes/{id}')
//   @response(204, {
//     description: 'Usertype DELETE success',
//   })
//   async deleteById(@param.path.number('id') id: number): Promise<void> {
//     await this.usertypeRepository.deleteById(id);
//   }
// }
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let UsertypeController = class UsertypeController {
    constructor(usertypeRepository) {
        this.usertypeRepository = usertypeRepository;
    }
    async create(usertype) {
        return this.usertypeRepository.create(usertype);
    }
    async count(where) {
        return this.usertypeRepository.count(where);
    }
    async find(filter) {
        return this.usertypeRepository.find(filter);
    }
    async updateAll(usertype, where) {
        return this.usertypeRepository.updateAll(usertype, where);
    }
    async findById(id, filter) {
        return this.usertypeRepository.findById(id, filter);
    }
    async updateById(id, usertype) {
        await this.usertypeRepository.updateById(id, usertype);
    }
    async replaceById(id, usertype) {
        await this.usertypeRepository.replaceById(id, usertype);
    }
    async deleteById(id) {
        await this.usertypeRepository.deleteById(id);
    }
};
exports.UsertypeController = UsertypeController;
tslib_1.__decorate([
    (0, rest_1.post)('/usertypes'),
    (0, rest_1.response)(200, {
        description: 'Usertype model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.Usertype) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.Usertype, {
                    title: 'NewUsertype',
                    exclude: ['userId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/usertypes/count'),
    (0, rest_1.response)(200, {
        description: 'Usertype model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.Usertype)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/usertypes'),
    (0, rest_1.response)(200, {
        description: 'Array of Usertype model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.Usertype, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.Usertype)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/usertypes'),
    (0, rest_1.response)(200, {
        description: 'Usertype PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.Usertype, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.Usertype)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.Usertype, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/usertypes/{id}'),
    (0, rest_1.response)(200, {
        description: 'Usertype model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.Usertype, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.Usertype, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/usertypes/{id}'),
    (0, rest_1.response)(204, {
        description: 'Usertype PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.Usertype, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.Usertype]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/usertypes/{id}'),
    (0, rest_1.response)(204, {
        description: 'Usertype PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.Usertype]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/usertypes/{id}'),
    (0, rest_1.response)(204, {
        description: 'Usertype DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], UsertypeController.prototype, "deleteById", null);
exports.UsertypeController = UsertypeController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.UsertypeRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.UsertypeRepository])
], UsertypeController);
//# sourceMappingURL=usertype.controller.js.map