import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Usertype } from '../models';
import { UsertypeRepository } from '../repositories';
export declare class UsertypeController {
    usertypeRepository: UsertypeRepository;
    constructor(usertypeRepository: UsertypeRepository);
    create(usertype: Omit<Usertype, 'userId'>): Promise<Usertype>;
    count(where?: Where<Usertype>): Promise<Count>;
    find(filter?: Filter<Usertype>): Promise<Usertype[]>;
    updateAll(usertype: Usertype, where?: Where<Usertype>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<Usertype>): Promise<Usertype>;
    updateById(id: number, usertype: Usertype): Promise<void>;
    replaceById(id: number, usertype: Usertype): Promise<void>;
    deleteById(id: number): Promise<void>;
}
