"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnderconstructionmasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let UnderconstructionmasterController = class UnderconstructionmasterController {
    constructor(underconstructionMasterRepository) {
        this.underconstructionMasterRepository = underconstructionMasterRepository;
    }
    async create(underconstructionMaster) {
        return this.underconstructionMasterRepository.create(underconstructionMaster);
    }
    async count(where) {
        return this.underconstructionMasterRepository.count(where);
    }
    async find(filter) {
        return this.underconstructionMasterRepository.find(filter);
    }
    async updateAll(underconstructionMaster, where) {
        return this.underconstructionMasterRepository.updateAll(underconstructionMaster, where);
    }
    async findById(id, filter) {
        return this.underconstructionMasterRepository.findById(id, filter);
    }
    async updateById(id, underconstructionMaster) {
        await this.underconstructionMasterRepository.updateById(id, underconstructionMaster);
    }
    async replaceById(id, underconstructionMaster) {
        await this.underconstructionMasterRepository.replaceById(id, underconstructionMaster);
    }
    async deleteById(id) {
        await this.underconstructionMasterRepository.deleteById(id);
    }
};
exports.UnderconstructionmasterController = UnderconstructionmasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/underconstruction-masters'),
    (0, rest_1.response)(200, {
        description: 'UnderconstructionMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.UnderconstructionMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.UnderconstructionMaster, {
                    title: 'NewUnderconstructionMaster',
                    exclude: ['underconstuctionId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/underconstruction-masters/count'),
    (0, rest_1.response)(200, {
        description: 'UnderconstructionMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.UnderconstructionMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/underconstruction-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of UnderconstructionMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.UnderconstructionMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.UnderconstructionMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/underconstruction-masters'),
    (0, rest_1.response)(200, {
        description: 'UnderconstructionMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.UnderconstructionMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.UnderconstructionMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.UnderconstructionMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/underconstruction-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'UnderconstructionMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.UnderconstructionMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.UnderconstructionMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/underconstruction-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'UnderconstructionMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.UnderconstructionMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.UnderconstructionMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/underconstruction-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'UnderconstructionMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.UnderconstructionMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/underconstruction-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'UnderconstructionMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], UnderconstructionmasterController.prototype, "deleteById", null);
exports.UnderconstructionmasterController = UnderconstructionmasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.UnderconstructionMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.UnderconstructionMasterRepository])
], UnderconstructionmasterController);
//# sourceMappingURL=underconstructionmaster.controller.js.map