/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { TestimonialMaster } from '../models';
import { TestimonialMasterRepository } from '../repositories';
export declare class TestimonialmasterController {
    testimonialMasterRepository: TestimonialMasterRepository;
    constructor(testimonialMasterRepository: TestimonialMasterRepository);
    private getMulterUpload;
    createWithImages(request: Request): Promise<TestimonialMaster>;
    create(testimonialMaster: Omit<TestimonialMaster, 'testimonialId'>): Promise<TestimonialMaster>;
    find(filter?: Filter<TestimonialMaster>): Promise<any[]>;
    findById(id: number, filter?: FilterExcludingWhere<TestimonialMaster>): Promise<any>;
    updateAll(testimonialMaster: TestimonialMaster, where?: Where<TestimonialMaster>): Promise<Count>;
    updateById(id: number, testimonialMaster: TestimonialMaster): Promise<void>;
    replaceById(id: number, testimonialMaster: TestimonialMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
