/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { SellerMaster } from '../models';
import { SellerMasterRepository } from '../repositories';
export declare class SellermasterController {
    private request;
    sellerMasterRepository: SellerMasterRepository;
    constructor(request: Request, sellerMasterRepository: SellerMasterRepository);
    createJson(sellerMaster: Omit<SellerMaster, 'sellerId'>): Promise<SellerMaster>;
    create(sellerMaster: Omit<SellerMaster, 'sellerId'>): Promise<SellerMaster>;
    count(where?: Where<SellerMaster>): Promise<Count>;
    find(filter?: Filter<SellerMaster>): Promise<SellerMaster[]>;
    findById(id: number, filter?: FilterExcludingWhere<SellerMaster>): Promise<SellerMaster>;
    updateById(id: number): Promise<void>;
    updateSellerMasterById(id: number): Promise<SellerMaster>;
    replaceById(id: number): Promise<void>;
    updateAll(sellerMaster: SellerMaster, where?: Where<SellerMaster>): Promise<Count>;
    deleteById(id: number): Promise<void>;
}
