import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { RecommendedLaunch } from '../models';
import { RecommendedLaunchRepository } from '../repositories';
export declare class RecommendedlaunchController {
    recommendedLaunchRepository: RecommendedLaunchRepository;
    constructor(recommendedLaunchRepository: RecommendedLaunchRepository);
    create(recommendedLaunch: Omit<RecommendedLaunch, 'reclaunchId '>): Promise<RecommendedLaunch>;
    count(where?: Where<RecommendedLaunch>): Promise<Count>;
    find(filter?: Filter<RecommendedLaunch>): Promise<RecommendedLaunch[]>;
    updateAll(recommendedLaunch: RecommendedLaunch, where?: Where<RecommendedLaunch>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<RecommendedLaunch>): Promise<RecommendedLaunch>;
    updateById(id: number, recommendedLaunch: RecommendedLaunch): Promise<void>;
    replaceById(id: number, recommendedLaunch: RecommendedLaunch): Promise<void>;
    deleteById(id: number): Promise<void>;
}
