"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadytomovemasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let ReadytomovemasterController = class ReadytomovemasterController {
    constructor(readyToMoveMasterRepository) {
        this.readyToMoveMasterRepository = readyToMoveMasterRepository;
    }
    async create(readyToMoveMaster) {
        return this.readyToMoveMasterRepository.create(readyToMoveMaster);
    }
    async count(where) {
        return this.readyToMoveMasterRepository.count(where);
    }
    async find(filter) {
        return this.readyToMoveMasterRepository.find(filter);
    }
    async updateAll(readyToMoveMaster, where) {
        return this.readyToMoveMasterRepository.updateAll(readyToMoveMaster, where);
    }
    async findById(id, filter) {
        return this.readyToMoveMasterRepository.findById(id, filter);
    }
    async updateById(id, readyToMoveMaster) {
        await this.readyToMoveMasterRepository.updateById(id, readyToMoveMaster);
    }
    async replaceById(id, readyToMoveMaster) {
        await this.readyToMoveMasterRepository.replaceById(id, readyToMoveMaster);
    }
    async deleteById(id) {
        await this.readyToMoveMasterRepository.deleteById(id);
    }
};
exports.ReadytomovemasterController = ReadytomovemasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/ready-to-move-masters'),
    (0, rest_1.response)(200, {
        description: 'ReadyToMoveMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.ReadyToMoveMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ReadyToMoveMaster, {
                    title: 'NewReadyToMoveMaster',
                    exclude: ['readytomoveId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ready-to-move-masters/count'),
    (0, rest_1.response)(200, {
        description: 'ReadyToMoveMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.ReadyToMoveMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ready-to-move-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of ReadyToMoveMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.ReadyToMoveMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.ReadyToMoveMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/ready-to-move-masters'),
    (0, rest_1.response)(200, {
        description: 'ReadyToMoveMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ReadyToMoveMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.ReadyToMoveMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.ReadyToMoveMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ready-to-move-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'ReadyToMoveMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ReadyToMoveMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.ReadyToMoveMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/ready-to-move-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'ReadyToMoveMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ReadyToMoveMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.ReadyToMoveMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/ready-to-move-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'ReadyToMoveMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.ReadyToMoveMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/ready-to-move-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'ReadyToMoveMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], ReadytomovemasterController.prototype, "deleteById", null);
exports.ReadytomovemasterController = ReadytomovemasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.ReadyToMoveMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.ReadyToMoveMasterRepository])
], ReadytomovemasterController);
//# sourceMappingURL=readytomovemaster.controller.js.map