"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublishTypeMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let PublishTypeMasterController = class PublishTypeMasterController {
    constructor(publishTypeMasterRepository) {
        this.publishTypeMasterRepository = publishTypeMasterRepository;
    }
    async create(publishTypeMaster) {
        return this.publishTypeMasterRepository.create(publishTypeMaster);
    }
    async count(where) {
        return this.publishTypeMasterRepository.count(where);
    }
    async find(filter) {
        return this.publishTypeMasterRepository.find(filter);
    }
    async updateAll(publishTypeMaster, where) {
        return this.publishTypeMasterRepository.updateAll(publishTypeMaster, where);
    }
    async findById(id, filter) {
        return this.publishTypeMasterRepository.findById(id, filter);
    }
    async updateById(id, publishTypeMaster) {
        await this.publishTypeMasterRepository.updateById(id, publishTypeMaster);
    }
    async replaceById(id, publishTypeMaster) {
        await this.publishTypeMasterRepository.replaceById(id, publishTypeMaster);
    }
    async deleteById(id) {
        await this.publishTypeMasterRepository.deleteById(id);
    }
};
exports.PublishTypeMasterController = PublishTypeMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/publish-type-masters'),
    (0, rest_1.response)(200, {
        description: 'PublishTypeMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.PublishTypeMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PublishTypeMaster, {
                    title: 'NewPublishTypeMaster',
                    exclude: ['publishTypeId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/publish-type-masters/count'),
    (0, rest_1.response)(200, {
        description: 'PublishTypeMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.PublishTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/publish-type-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of PublishTypeMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.PublishTypeMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.PublishTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/publish-type-masters'),
    (0, rest_1.response)(200, {
        description: 'PublishTypeMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PublishTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.PublishTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.PublishTypeMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/publish-type-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'PublishTypeMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PublishTypeMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.PublishTypeMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/publish-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PublishTypeMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PublishTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PublishTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/publish-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PublishTypeMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PublishTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/publish-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PublishTypeMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], PublishTypeMasterController.prototype, "deleteById", null);
exports.PublishTypeMasterController = PublishTypeMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.PublishTypeMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.PublishTypeMasterRepository])
], PublishTypeMasterController);
//# sourceMappingURL=publish-type-master.controller.js.map