"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PosttpemasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let PosttpemasterController = class PosttpemasterController {
    constructor(postTypeMasterRepository) {
        this.postTypeMasterRepository = postTypeMasterRepository;
    }
    async create(postTypeMaster) {
        return this.postTypeMasterRepository.create(postTypeMaster);
    }
    async count(where) {
        return this.postTypeMasterRepository.count(where);
    }
    async find(filter) {
        return this.postTypeMasterRepository.find(filter);
    }
    async updateAll(postTypeMaster, where) {
        return this.postTypeMasterRepository.updateAll(postTypeMaster, where);
    }
    async findById(id, filter) {
        return this.postTypeMasterRepository.findById(id, filter);
    }
    async updateById(id, postTypeMaster) {
        await this.postTypeMasterRepository.updateById(id, postTypeMaster);
    }
    async replaceById(id, postTypeMaster) {
        await this.postTypeMasterRepository.replaceById(id, postTypeMaster);
    }
    async deleteById(id) {
        await this.postTypeMasterRepository.deleteById(id);
    }
};
exports.PosttpemasterController = PosttpemasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/post-type-masters'),
    (0, rest_1.response)(200, {
        description: 'PostTypeMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.PostTypeMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostTypeMaster, {
                    title: 'NewPostTypeMaster',
                    exclude: ['postTypeId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/post-type-masters/count'),
    (0, rest_1.response)(200, {
        description: 'PostTypeMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.PostTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/post-type-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of PostTypeMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.PostTypeMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.PostTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/post-type-masters'),
    (0, rest_1.response)(200, {
        description: 'PostTypeMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.PostTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.PostTypeMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/post-type-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'PostTypeMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostTypeMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.PostTypeMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/post-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PostTypeMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PostTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/post-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PostTypeMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PostTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/post-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PostTypeMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], PosttpemasterController.prototype, "deleteById", null);
exports.PosttpemasterController = PosttpemasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.PostTypeMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.PostTypeMasterRepository])
], PosttpemasterController);
//# sourceMappingURL=posttpemaster.controller.js.map