import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { PostTypeMaster } from '../models';
import { PostTypeMasterRepository } from '../repositories';
export declare class PosttpemasterController {
    postTypeMasterRepository: PostTypeMasterRepository;
    constructor(postTypeMasterRepository: PostTypeMasterRepository);
    create(postTypeMaster: Omit<PostTypeMaster, 'postTypeId'>): Promise<PostTypeMaster>;
    count(where?: Where<PostTypeMaster>): Promise<Count>;
    find(filter?: Filter<PostTypeMaster>): Promise<PostTypeMaster[]>;
    updateAll(postTypeMaster: PostTypeMaster, where?: Where<PostTypeMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<PostTypeMaster>): Promise<PostTypeMaster>;
    updateById(id: number, postTypeMaster: PostTypeMaster): Promise<void>;
    replaceById(id: number, postTypeMaster: PostTypeMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
