/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { PostPropertyMaster } from '../models';
import { BestpropertyLaunchRepository, NewLaunchMasterRepository, PostPropertyAmenitiesRepository, PostPropertyMasterRepository, RecommendedLaunchRepository } from '../repositories';
export declare class PostpropertymasterController {
    postPropertyMasterRepository: PostPropertyMasterRepository;
    recommendedLaunchRepository: RecommendedLaunchRepository;
    bestpropertyLaunch: BestpropertyLaunchRepository;
    propertyAmenitiesRepository: PostPropertyAmenitiesRepository;
    newLaunchRepository: NewLaunchMasterRepository;
    constructor(postPropertyMasterRepository: PostPropertyMasterRepository, recommendedLaunchRepository: RecommendedLaunchRepository, bestpropertyLaunch: BestpropertyLaunchRepository, propertyAmenitiesRepository: PostPropertyAmenitiesRepository, newLaunchRepository: NewLaunchMasterRepository);
    saveImageFromPathOrUrl(imagePath: string): Promise<string>;
    private getMulterUpload;
    createWithPhotos(request: Request): Promise<PostPropertyMaster>;
    create(postPropertyMaster: Omit<PostPropertyMaster, 'postpropertyId'>): Promise<PostPropertyMaster>;
    count(where?: Where<PostPropertyMaster>): Promise<Count>;
    find(filter?: Filter<PostPropertyMaster>): Promise<any[]>;
    updateAll(postPropertyMaster: PostPropertyMaster, where?: Where<PostPropertyMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<PostPropertyMaster>): Promise<any>;
    getRecommended(): Promise<any[]>;
    getRecommendedFromRecommendedLaunch(): Promise<any[]>;
    getBestValue(): Promise<any[]>;
    getBestpropertyFromBestLaunch(): Promise<any[]>;
    getNewLaunchFromLaunchTable(): Promise<any[]>;
    getAllNewLaunch(): Promise<any[]>;
    updateWithPhotos(id: number, request: Request): Promise<void>;
    replaceById(id: number, postPropertyMaster: PostPropertyMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
    getPublishedActive(fkcityId?: string, fkpostType?: number, fklocalityId?: string, fkpropertytypeId?: number, fkfurnishingtypeId?: number, fktransactionId?: number, fkpossessionId?: number, fkfacingId?: number, fkmainpropertytypeId?: number, fkuserId?: number, RERA_is_active?: number, Property_Title?: string): Promise<any[]>;
    getPublishedActiveById(id: number, filter?: FilterExcludingWhere<PostPropertyMaster>): Promise<any>;
}
