"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PossessionMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let PossessionMasterController = class PossessionMasterController {
    constructor(possessionMasterRepository) {
        this.possessionMasterRepository = possessionMasterRepository;
    }
    async create(possessionMaster) {
        return this.possessionMasterRepository.create(possessionMaster);
    }
    async count(where) {
        return this.possessionMasterRepository.count(where);
    }
    async find(filter) {
        return this.possessionMasterRepository.find(filter);
    }
    async updateAll(possessionMaster, where) {
        return this.possessionMasterRepository.updateAll(possessionMaster, where);
    }
    async findById(id, filter) {
        return this.possessionMasterRepository.findById(id, filter);
    }
    async updateById(id, possessionMaster) {
        await this.possessionMasterRepository.updateById(id, possessionMaster);
    }
    async replaceById(id, possessionMaster) {
        await this.possessionMasterRepository.replaceById(id, possessionMaster);
    }
    async deleteById(id) {
        await this.possessionMasterRepository.deleteById(id);
    }
};
exports.PossessionMasterController = PossessionMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/possession-masters'),
    (0, rest_1.response)(200, {
        description: 'PossessionMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.PossessionMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PossessionMaster, {
                    title: 'NewPossessionMaster',
                    exclude: ['possessionId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/possession-masters/count'),
    (0, rest_1.response)(200, {
        description: 'PossessionMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.PossessionMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/possession-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of PossessionMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.PossessionMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.PossessionMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/possession-masters'),
    (0, rest_1.response)(200, {
        description: 'PossessionMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PossessionMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.PossessionMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.PossessionMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/possession-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'PossessionMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PossessionMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.PossessionMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/possession-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PossessionMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PossessionMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PossessionMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/possession-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PossessionMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PossessionMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/possession-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PossessionMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], PossessionMasterController.prototype, "deleteById", null);
exports.PossessionMasterController = PossessionMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.PossessionMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.PossessionMasterRepository])
], PossessionMasterController);
//# sourceMappingURL=possession-master.controller.js.map