/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { PackageMaster } from '../models';
import { PackageMasterRepository } from '../repositories';
export declare class PackageMasterController {
    packageMasterRepository: PackageMasterRepository;
    constructor(packageMasterRepository: PackageMasterRepository);
    create(packageMaster: Omit<PackageMaster, 'packageId'>): Promise<PackageMaster>;
    createWithFile(request: Request, response: any): Promise<PackageMaster>;
    count(where?: Where<PackageMaster>): Promise<Count>;
    find(filter?: Filter<PackageMaster>): Promise<PackageMaster[]>;
    findById(id: number, filter?: FilterExcludingWhere<PackageMaster>): Promise<PackageMaster>;
    updateById(id: number, packageMaster: PackageMaster): Promise<void>;
    updateByIdWithFile(id: number, request: Request, response: any): Promise<void>;
    replaceById(id: number, packageMaster: PackageMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
    softDeletePackage(id: number, deleteData?: {
        deletedBy?: number;
        deleteRemark?: string;
    }): Promise<void>;
}
