"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OwnershipmasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let OwnershipmasterController = class OwnershipmasterController {
    constructor(ownershipMasterRepository) {
        this.ownershipMasterRepository = ownershipMasterRepository;
    }
    async create(ownershipMaster) {
        return this.ownershipMasterRepository.create(ownershipMaster);
    }
    async count(where) {
        return this.ownershipMasterRepository.count(where);
    }
    async find(filter) {
        return this.ownershipMasterRepository.find(filter);
    }
    async updateAll(ownershipMaster, where) {
        return this.ownershipMasterRepository.updateAll(ownershipMaster, where);
    }
    async findById(id, filter) {
        return this.ownershipMasterRepository.findById(id, filter);
    }
    async updateById(id, ownershipMaster) {
        await this.ownershipMasterRepository.updateById(id, ownershipMaster);
    }
    async replaceById(id, ownershipMaster) {
        await this.ownershipMasterRepository.replaceById(id, ownershipMaster);
    }
    async deleteById(id) {
        await this.ownershipMasterRepository.deleteById(id);
    }
};
exports.OwnershipmasterController = OwnershipmasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/ownership-masters'),
    (0, rest_1.response)(200, {
        description: 'OwnershipMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.OwnershipMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.OwnershipMaster, {
                    title: 'NewOwnershipMaster',
                    exclude: ['ownershipId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ownership-masters/count'),
    (0, rest_1.response)(200, {
        description: 'OwnershipMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.OwnershipMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ownership-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of OwnershipMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.OwnershipMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.OwnershipMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/ownership-masters'),
    (0, rest_1.response)(200, {
        description: 'OwnershipMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.OwnershipMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.OwnershipMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.OwnershipMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ownership-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'OwnershipMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.OwnershipMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.OwnershipMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/ownership-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'OwnershipMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.OwnershipMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.OwnershipMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/ownership-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'OwnershipMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.OwnershipMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/ownership-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'OwnershipMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], OwnershipmasterController.prototype, "deleteById", null);
exports.OwnershipmasterController = OwnershipmasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.OwnershipMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.OwnershipMasterRepository])
], OwnershipmasterController);
//# sourceMappingURL=ownershipmaster.controller.js.map