import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { OwnershipMaster } from '../models';
import { OwnershipMasterRepository } from '../repositories';
export declare class OwnershipmasterController {
    ownershipMasterRepository: OwnershipMasterRepository;
    constructor(ownershipMasterRepository: OwnershipMasterRepository);
    create(ownershipMaster: Omit<OwnershipMaster, 'ownershipId'>): Promise<OwnershipMaster>;
    count(where?: Where<OwnershipMaster>): Promise<Count>;
    find(filter?: Filter<OwnershipMaster>): Promise<OwnershipMaster[]>;
    updateAll(ownershipMaster: OwnershipMaster, where?: Where<OwnershipMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<OwnershipMaster>): Promise<OwnershipMaster>;
    updateById(id: number, ownershipMaster: OwnershipMaster): Promise<void>;
    replaceById(id: number, ownershipMaster: OwnershipMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
