"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogPropertyController = void 0;
const tslib_1 = require("tslib");
/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable @typescript-eslint/no-unused-vars */
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let LogPropertyController = class LogPropertyController {
    constructor(logPropertyRepository) {
        this.logPropertyRepository = logPropertyRepository;
    }
    // Helper function to remove unwanted fields from log property
    cleanLogProperty(logProperty) {
        const { isDefault, isOn, isActive, createdDate, createdBy, modifiedDate, modifiedBy, deletedDate, deletedBy, deleteRemark, lastChanged, ...cleanedLogProperty } = logProperty;
        return cleanedLogProperty;
    }
    // Helper function to clean nested objects
    cleanNestedObjects(logProperty) {
        // Clean usertype if exists
        if (logProperty.usertype) {
            const { isDefault: userTypeIsDefault, isOn: userTypeIsOn, isActive: userTypeIsActive, createdDate: userTypeCreatedDate, createdBy: userTypeCreatedBy, modifiedDate: userTypeModifiedDate, modifiedBy: userTypeModifiedBy, deletedDate: userTypeDeletedDate, deletedBy: userTypeDeletedBy, deleteRemark: userTypeDeleteRemark, lastChanged: userTypeLastChanged, ...cleanedUsertype } = logProperty.usertype;
            logProperty.usertype = cleanedUsertype;
        }
        // Clean buyer if exists
        if (logProperty.buyer) {
            const { isDefault: buyerIsDefault, isOn: buyerIsOn, isActive: buyerIsActive, createdDate: buyerCreatedDate, createdBy: buyerCreatedBy, modifiedDate: buyerModifiedDate, modifiedBy: buyerModifiedBy, deletedDate: buyerDeletedDate, deletedBy: buyerDeletedBy, deleteRemark: buyerDeleteRemark, lastChanged: buyerLastChanged, ...cleanedBuyer } = logProperty.buyer;
            // Clean nested city if exists
            if (cleanedBuyer.city) {
                const { isDefault: cityIsDefault, isOn: cityIsOn, isActive: cityIsActive, createdDate: cityCreatedDate, createdBy: cityCreatedBy, modifiedDate: cityModifiedDate, modifiedBy: cityModifiedBy, deletedDate: cityDeletedDate, deletedBy: cityDeletedBy, deleteRemark: cityDeleteRemark, lastChanged: cityLastChanged, ...cleanedCity } = cleanedBuyer.city;
                cleanedBuyer.city = cleanedCity;
            }
            // Clean nested gender if exists
            if (cleanedBuyer.gender) {
                const { isDefault: genderIsDefault, isOn: genderIsOn, isActive: genderIsActive, createdDate: genderCreatedDate, createdBy: genderCreatedBy, modifiedDate: genderModifiedDate, modifiedBy: genderModifiedBy, deletedDate: genderDeletedDate, deletedBy: genderDeletedBy, deleteRemark: genderDeleteRemark, lastChanged: genderLastChanged, ...cleanedGender } = cleanedBuyer.gender;
                cleanedBuyer.gender = cleanedGender;
            }
            // Clean nested usertype if exists
            if (cleanedBuyer.usertype) {
                const { isDefault: buyerUserTypeIsDefault, isOn: buyerUserTypeIsOn, isActive: buyerUserTypeIsActive, createdDate: buyerUserTypeCreatedDate, createdBy: buyerUserTypeCreatedBy, modifiedDate: buyerUserTypeModifiedDate, modifiedBy: buyerUserTypeModifiedBy, deletedDate: buyerUserTypeDeletedDate, deletedBy: buyerUserTypeDeletedBy, deleteRemark: buyerUserTypeDeleteRemark, lastChanged: buyerUserTypeLastChanged, ...cleanedBuyerUsertype } = cleanedBuyer.usertype;
                cleanedBuyer.usertype = cleanedBuyerUsertype;
            }
            logProperty.buyer = cleanedBuyer;
        }
        // Clean seller if exists
        if (logProperty.seller) {
            const { isDefault: sellerIsDefault, isOn: sellerIsOn, isActive: sellerIsActive, createdDate: sellerCreatedDate, createdBy: sellerCreatedBy, modifiedDate: sellerModifiedDate, modifiedBy: sellerModifiedBy, deletedDate: sellerDeletedDate, deletedBy: sellerDeletedBy, deleteRemark: sellerDeleteRemark, lastChanged: sellerLastChanged, ...cleanedSeller } = logProperty.seller;
            // Clean nested city if exists
            if (cleanedSeller.city) {
                const { isDefault: cityIsDefault, isOn: cityIsOn, isActive: cityIsActive, createdDate: cityCreatedDate, createdBy: cityCreatedBy, modifiedDate: cityModifiedDate, modifiedBy: cityModifiedBy, deletedDate: cityDeletedDate, deletedBy: cityDeletedBy, deleteRemark: cityDeleteRemark, lastChanged: cityLastChanged, ...cleanedCity } = cleanedSeller.city;
                cleanedSeller.city = cleanedCity;
            }
            // Clean nested package if exists
            if (cleanedSeller.package) {
                const { isDefault: packageIsDefault, isOn: packageIsOn, isActive: packageIsActive, createdDate: packageCreatedDate, createdBy: packageCreatedBy, modifiedDate: packageModifiedDate, modifiedBy: packageModifiedBy, deletedDate: packageDeletedDate, deletedBy: packageDeletedBy, deleteRemark: packageDeleteRemark, lastChanged: packageLastChanged, ...cleanedPackage } = cleanedSeller.package;
                cleanedSeller.package = cleanedPackage;
            }
            // Clean nested user if exists
            if (cleanedSeller.user) {
                const { isDefault: userIsDefault, isOn: userIsOn, isActive: userIsActive, createdDate: userCreatedDate, createdBy: userCreatedBy, modifiedDate: userModifiedDate, modifiedBy: userModifiedBy, deletedDate: userDeletedDate, deletedBy: userDeletedBy, deleteRemark: userDeleteRemark, lastChanged: userLastChanged, ...cleanedUser } = cleanedSeller.user;
                cleanedSeller.user = cleanedUser;
            }
            // Clean nested gender if exists
            if (cleanedSeller.gender) {
                const { isDefault: genderIsDefault, isOn: genderIsOn, isActive: genderIsActive, createdDate: genderCreatedDate, createdBy: genderCreatedBy, modifiedDate: genderModifiedDate, modifiedBy: genderModifiedBy, deletedDate: genderDeletedDate, deletedBy: genderDeletedBy, deleteRemark: genderDeleteRemark, lastChanged: genderLastChanged, ...cleanedGender } = cleanedSeller.gender;
                cleanedSeller.gender = cleanedGender;
            }
            logProperty.seller = cleanedSeller;
        }
        // Clean postProperty if exists
        if (logProperty.postProperty) {
            const { isDefault: postPropertyIsDefault, isOn: postPropertyIsOn, isActive: postPropertyIsActive, createdDate: postPropertyCreatedDate, createdBy: postPropertyCreatedBy, modifiedDate: postPropertyModifiedDate, modifiedBy: postPropertyModifiedBy, deletedDate: postPropertyDeletedDate, deletedBy: postPropertyDeletedBy, deleteRemark: postPropertyDeleteRemark, lastChanged: postPropertyLastChanged, ...cleanedPostProperty } = logProperty.postProperty;
            logProperty.postProperty = cleanedPostProperty;
        }
        return logProperty;
    }
    async create(logProperty) {
        return this.logPropertyRepository.create(logProperty);
    }
    async count(where) {
        return this.logPropertyRepository.count(where);
    }
    async find(filter) {
        // Include usertype, buyer, and seller relations
        const enhancedFilter = {
            ...filter,
            include: [
                { relation: 'usertype' },
                { relation: 'buyer' },
                { relation: 'seller' },
                { relation: 'postProperty' }
            ],
        };
        const logProperties = await this.logPropertyRepository.find(enhancedFilter);
        // Clean each log property
        return logProperties.map(logProperty => {
            let cleanedLogProperty = this.cleanLogProperty(logProperty);
            cleanedLogProperty = this.cleanNestedObjects(cleanedLogProperty);
            return cleanedLogProperty;
        });
    }
    async updateAll(logProperty, where) {
        return this.logPropertyRepository.updateAll(logProperty, where);
    }
    async findById(id, filter) {
        // Include usertype, buyer, and seller relations
        const enhancedFilter = {
            ...filter,
            include: [
                { relation: 'usertype' },
                { relation: 'buyer' },
                { relation: 'seller' },
                { relation: 'postProperty' }
            ],
        };
        const logProperty = await this.logPropertyRepository.findById(id, enhancedFilter);
        // Clean the log property
        let cleanedLogProperty = this.cleanLogProperty(logProperty);
        cleanedLogProperty = this.cleanNestedObjects(cleanedLogProperty);
        return cleanedLogProperty;
    }
    async updateById(id, logProperty) {
        await this.logPropertyRepository.updateById(id, logProperty);
    }
    async replaceById(id, logProperty) {
        await this.logPropertyRepository.replaceById(id, logProperty);
    }
    async deleteById(id) {
        await this.logPropertyRepository.deleteById(id);
    }
    // Get logs by buyer ID
    async findByBuyer(buyerId) {
        const logProperties = await this.logPropertyRepository.find({
            where: {
                fkBuyerIdSellerId: buyerId,
                fkUsertypeId: 1, // Buyer usertype
            },
            include: [
                { relation: 'usertype' },
                { relation: 'buyer' },
                { relation: 'postProperty' }
            ],
        });
        // Clean each log property
        return logProperties.map(logProperty => {
            let cleanedLogProperty = this.cleanLogProperty(logProperty);
            cleanedLogProperty = this.cleanNestedObjects(cleanedLogProperty);
            return cleanedLogProperty;
        });
    }
    // Get logs by seller ID
    async findBySeller(sellerId) {
        const logProperties = await this.logPropertyRepository.find({
            where: {
                fkBuyerIdSellerId: sellerId,
                fkUsertypeId: { neq: 1 },
            },
            include: [
                { relation: 'usertype' },
                { relation: 'seller' },
                { relation: 'postProperty' }
            ],
        });
        // Clean each log property
        return logProperties.map(logProperty => {
            let cleanedLogProperty = this.cleanLogProperty(logProperty);
            cleanedLogProperty = this.cleanNestedObjects(cleanedLogProperty);
            return cleanedLogProperty;
        });
    }
    async getLogCountByUser(userId, userTypeId) {
        const whereCondition = {
            fkBuyerIdSellerId: userId,
            fkUsertypeId: userTypeId,
            isActive: 1, // remove if not needed
        };
        console.log('LOG COUNT WHERE =>', whereCondition);
        return this.logPropertyRepository.count(whereCondition);
    }
};
exports.LogPropertyController = LogPropertyController;
tslib_1.__decorate([
    (0, rest_1.post)('/log-properties'),
    (0, rest_1.response)(200, {
        description: 'LogProperty model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.LogProperty) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, {
                    title: 'NewLogProperty',
                    exclude: ['logPropertyId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-properties/count'),
    (0, rest_1.response)(200, {
        description: 'LogProperty model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.LogProperty)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-properties'),
    (0, rest_1.response)(200, {
        description: 'Array of LogProperty model instances with relations',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.LogProperty)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/log-properties'),
    (0, rest_1.response)(200, {
        description: 'LogProperty PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.LogProperty)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.LogProperty, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-properties/{id}'),
    (0, rest_1.response)(200, {
        description: 'LogProperty model instance with relations',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.LogProperty, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/log-properties/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogProperty PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.LogProperty]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/log-properties/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogProperty PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.LogProperty]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/log-properties/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogProperty DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "deleteById", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-properties/buyer/{buyerId}'),
    (0, rest_1.response)(200, {
        description: 'Array of LogProperty for a specific buyer',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('buyerId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "findByBuyer", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-properties/seller/{sellerId}'),
    (0, rest_1.response)(200, {
        description: 'Array of LogProperty for a specific seller',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.LogProperty, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('sellerId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "findBySeller", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-properties/user/{userId}/{userTypeId}/count'),
    (0, rest_1.response)(200, {
        description: 'LogProperty count for specific user',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.path.number('userId')),
    tslib_1.__param(1, rest_1.param.path.number('userTypeId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Number]),
    tslib_1.__metadata("design:returntype", Promise)
], LogPropertyController.prototype, "getLogCountByUser", null);
exports.LogPropertyController = LogPropertyController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.LogPropertyRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.LogPropertyRepository])
], LogPropertyController);
//# sourceMappingURL=log-property.controller.js.map