import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { LogProperty, LogPropertyRelations } from '../models';
import { LogPropertyRepository } from '../repositories';
export declare class LogPropertyController {
    logPropertyRepository: LogPropertyRepository;
    constructor(logPropertyRepository: LogPropertyRepository);
    private cleanLogProperty;
    private cleanNestedObjects;
    create(logProperty: Omit<LogProperty, 'logPropertyId'>): Promise<LogProperty>;
    count(where?: Where<LogProperty>): Promise<Count>;
    find(filter?: Filter<LogProperty>): Promise<(LogProperty & LogPropertyRelations)[]>;
    updateAll(logProperty: LogProperty, where?: Where<LogProperty>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<LogProperty>): Promise<LogProperty & LogPropertyRelations>;
    updateById(id: number, logProperty: LogProperty): Promise<void>;
    replaceById(id: number, logProperty: LogProperty): Promise<void>;
    deleteById(id: number): Promise<void>;
    findByBuyer(buyerId: number): Promise<(LogProperty & LogPropertyRelations)[]>;
    findBySeller(sellerId: number): Promise<(LogProperty & LogPropertyRelations)[]>;
    getLogCountByUser(userId: number, userTypeId: number): Promise<Count>;
}
