"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogBuyerController = void 0;
const tslib_1 = require("tslib");
/* eslint-disable @typescript-eslint/no-explicit-any */
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
// Helper function to remove unwanted fields
function cleanLogBuyerData(data) {
    const fieldsToRemove = [
        'isDefault',
        'isOn',
        'isActive',
        'createdDate',
        'createdBy',
        'modifiedDate',
        'modifiedBy',
        'deletedDate',
        'deletedBy',
        'deleteRemark',
        'lastChanged'
    ];
    // Deep clone to avoid modifying original object
    const cleanData = JSON.parse(JSON.stringify(data));
    // Remove fields from main object
    fieldsToRemove.forEach(field => {
        delete cleanData[field];
    });
    // Remove fields from postProperty if it exists
    if (cleanData.postProperty) {
        fieldsToRemove.forEach(field => {
            delete cleanData.postProperty[field];
        });
    }
    // Remove fields from buyer if it exists
    if (cleanData.buyer) {
        fieldsToRemove.forEach(field => {
            delete cleanData.buyer[field];
        });
    }
    return cleanData;
}
let LogBuyerController = class LogBuyerController {
    constructor(logBuyerRepository) {
        this.logBuyerRepository = logBuyerRepository;
    }
    async create(logBuyer) {
        return this.logBuyerRepository.create(logBuyer);
    }
    async count(where) {
        return this.logBuyerRepository.count(where);
    }
    async find(filter) {
        // Add buyer and postProperty relations to filter
        const f = {
            ...filter,
            include: ['buyer', 'postProperty'],
        };
        const data = await this.logBuyerRepository.find(f);
        return data.map(cleanLogBuyerData);
    }
    async updateAll(logBuyer, where) {
        return this.logBuyerRepository.updateAll(logBuyer, where);
    }
    async findById(id, filter) {
        // Add buyer and postProperty relations to filter
        const f = {
            ...filter,
            include: ['buyer', 'postProperty'],
        };
        const data = await this.logBuyerRepository.findById(id, f);
        return cleanLogBuyerData(data);
    }
    async updateById(id, logBuyer) {
        await this.logBuyerRepository.updateById(id, logBuyer);
    }
    async replaceById(id, logBuyer) {
        await this.logBuyerRepository.replaceById(id, logBuyer);
    }
    async deleteById(id) {
        await this.logBuyerRepository.deleteById(id);
    }
};
exports.LogBuyerController = LogBuyerController;
tslib_1.__decorate([
    (0, rest_1.post)('/log-buyers'),
    (0, rest_1.response)(200, {
        description: 'LogBuyer model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyer) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyer, {
                    title: 'NewLogBuyer',
                    exclude: ['logBuyerId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-buyers/count'),
    (0, rest_1.response)(200, {
        description: 'LogBuyer model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.LogBuyer)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-buyers'),
    (0, rest_1.response)(200, {
        description: 'Array of LogBuyer model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.LogBuyer, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.LogBuyer)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/log-buyers'),
    (0, rest_1.response)(200, {
        description: 'LogBuyer PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyer, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.LogBuyer)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.LogBuyer, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-buyers/{id}'),
    (0, rest_1.response)(200, {
        description: 'LogBuyer model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyer, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.LogBuyer, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/log-buyers/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogBuyer PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyer, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.LogBuyer]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/log-buyers/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogBuyer PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.LogBuyer]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/log-buyers/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogBuyer DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyerController.prototype, "deleteById", null);
exports.LogBuyerController = LogBuyerController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.LogBuyerRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.LogBuyerRepository])
], LogBuyerController);
//# sourceMappingURL=log-buyer.controller.js.map