"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenderMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let GenderMasterController = class GenderMasterController {
    constructor(genderMasterRepository) {
        this.genderMasterRepository = genderMasterRepository;
    }
    async create(genderMaster) {
        return this.genderMasterRepository.create(genderMaster);
    }
    async count(where) {
        return this.genderMasterRepository.count(where);
    }
    async find(filter) {
        return this.genderMasterRepository.find(filter);
    }
    async updateAll(genderMaster, where) {
        return this.genderMasterRepository.updateAll(genderMaster, where);
    }
    async findById(id, filter) {
        return this.genderMasterRepository.findById(id, filter);
    }
    async updateById(id, genderMaster) {
        await this.genderMasterRepository.updateById(id, genderMaster);
    }
    async replaceById(id, genderMaster) {
        await this.genderMasterRepository.replaceById(id, genderMaster);
    }
    async deleteById(id) {
        await this.genderMasterRepository.deleteById(id);
    }
};
exports.GenderMasterController = GenderMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/gender-masters'),
    (0, rest_1.response)(200, {
        description: 'GenderMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.GenderMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.GenderMaster, {
                    title: 'NewGenderMaster',
                    exclude: ['genderId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/gender-masters/count'),
    (0, rest_1.response)(200, {
        description: 'GenderMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.GenderMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/gender-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of GenderMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.GenderMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.GenderMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/gender-masters'),
    (0, rest_1.response)(200, {
        description: 'GenderMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.GenderMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.GenderMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.GenderMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/gender-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'GenderMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.GenderMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.GenderMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/gender-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'GenderMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.GenderMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.GenderMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/gender-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'GenderMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.GenderMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/gender-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'GenderMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], GenderMasterController.prototype, "deleteById", null);
exports.GenderMasterController = GenderMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.GenderMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.GenderMasterRepository])
], GenderMasterController);
//# sourceMappingURL=gender-master.controller.js.map