"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FurnishingmasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let FurnishingmasterController = class FurnishingmasterController {
    constructor(furnishingMasterRepository) {
        this.furnishingMasterRepository = furnishingMasterRepository;
    }
    async create(furnishingMaster) {
        return this.furnishingMasterRepository.create(furnishingMaster);
    }
    async count(where) {
        return this.furnishingMasterRepository.count(where);
    }
    async find(filter) {
        return this.furnishingMasterRepository.find(filter);
    }
    async updateAll(furnishingMaster, where) {
        return this.furnishingMasterRepository.updateAll(furnishingMaster, where);
    }
    async findById(id, filter) {
        return this.furnishingMasterRepository.findById(id, filter);
    }
    async updateById(id, furnishingMaster) {
        await this.furnishingMasterRepository.updateById(id, furnishingMaster);
    }
    async replaceById(id, furnishingMaster) {
        await this.furnishingMasterRepository.replaceById(id, furnishingMaster);
    }
    async deleteById(id) {
        await this.furnishingMasterRepository.deleteById(id);
    }
};
exports.FurnishingmasterController = FurnishingmasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/furnishing-masters'),
    (0, rest_1.response)(200, {
        description: 'FurnishingMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.FurnishingMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FurnishingMaster, {
                    title: 'NewFurnishingMaster',
                    exclude: ['furnishingId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/furnishing-masters/count'),
    (0, rest_1.response)(200, {
        description: 'FurnishingMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.FurnishingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/furnishing-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of FurnishingMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.FurnishingMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.FurnishingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/furnishing-masters'),
    (0, rest_1.response)(200, {
        description: 'FurnishingMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FurnishingMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.FurnishingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.FurnishingMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/furnishing-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'FurnishingMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FurnishingMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.FurnishingMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/furnishing-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FurnishingMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FurnishingMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.FurnishingMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/furnishing-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FurnishingMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.FurnishingMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/furnishing-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FurnishingMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], FurnishingmasterController.prototype, "deleteById", null);
exports.FurnishingmasterController = FurnishingmasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.FurnishingMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.FurnishingMasterRepository])
], FurnishingmasterController);
//# sourceMappingURL=furnishingmaster.controller.js.map