import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { FloorMaster } from '../models';
import { FloorMasterRepository } from '../repositories';
export declare class FloormasterController {
    floorMasterRepository: FloorMasterRepository;
    constructor(floorMasterRepository: FloorMasterRepository);
    create(floorMaster: Omit<FloorMaster, 'floorId'>): Promise<FloorMaster>;
    count(where?: Where<FloorMaster>): Promise<Count>;
    find(filter?: Filter<FloorMaster>): Promise<FloorMaster[]>;
    updateAll(floorMaster: FloorMaster, where?: Where<FloorMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<FloorMaster>): Promise<FloorMaster>;
    updateById(id: number, floorMaster: FloorMaster): Promise<void>;
    replaceById(id: number, floorMaster: FloorMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
