"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FacingMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let FacingMasterController = class FacingMasterController {
    constructor(facingMasterRepository) {
        this.facingMasterRepository = facingMasterRepository;
    }
    async create(facingMaster) {
        return this.facingMasterRepository.create(facingMaster);
    }
    async count(where) {
        return this.facingMasterRepository.count(where);
    }
    async find(filter) {
        return this.facingMasterRepository.find(filter);
    }
    async updateAll(facingMaster, where) {
        return this.facingMasterRepository.updateAll(facingMaster, where);
    }
    async findById(id, filter) {
        return this.facingMasterRepository.findById(id, filter);
    }
    async updateById(id, facingMaster) {
        await this.facingMasterRepository.updateById(id, facingMaster);
    }
    async replaceById(id, facingMaster) {
        await this.facingMasterRepository.replaceById(id, facingMaster);
    }
    async deleteById(id) {
        await this.facingMasterRepository.deleteById(id);
    }
};
exports.FacingMasterController = FacingMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/facing-masters'),
    (0, rest_1.response)(200, {
        description: 'FacingMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.FacingMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FacingMaster, {
                    title: 'NewFacingMaster',
                    exclude: ['facingId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/facing-masters/count'),
    (0, rest_1.response)(200, {
        description: 'FacingMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.FacingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/facing-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of FacingMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.FacingMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.FacingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/facing-masters'),
    (0, rest_1.response)(200, {
        description: 'FacingMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FacingMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.FacingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.FacingMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/facing-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'FacingMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FacingMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.FacingMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/facing-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FacingMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FacingMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.FacingMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/facing-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FacingMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.FacingMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/facing-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FacingMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], FacingMasterController.prototype, "deleteById", null);
exports.FacingMasterController = FacingMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.FacingMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.FacingMasterRepository])
], FacingMasterController);
//# sourceMappingURL=facing-master.controller.js.map